/****************************************************************************
* Donohue and Wolfers (2006) 
* Table 2
* Panel Data Estimates of the Effects of Death Penalty Laws 
* on Murder Rates 1960-2000
****************************************************************************/


clear
set mat 800
set mem 250m
set more off
cd  "..."
use "StatePanel.dta", clear

gen decade_ds=10*int(year/10)

xi: reg pc_mur legal rpc_inc ur ipolice nonwhite age15to19 age20to24 i.st i.decade_ds [w=popul] if sample_ds==1, cluster(st)
xi: reg pc_mur legal rpc_inc ur ipolice nonwhite age15to19 age20to24 i.st i.year i.decade_ds [w=popul] if sample_ds==1, cluster(st)

gen ex10=0
for num 1/10: replace ex10=ex10+lX.execs
replace ex10=1 if ex10>0
gen active=legal*ex10
gen passive=legal*(ex10==0)
xi: reg pc_mur active passive rpc_inc ur ipolice nonwhite age15to19 age20to24 i.st i.year i.decade_ds [w=popul] if sample_ds==1, cluster(st)
